# 🏗️ Mimari Tasarım Dokümantasyonu

## 📋 Dokümandan Çıkarılan Gereksinimler

### 1. Ürün Ailesi Yönetimi
- **Turlar & Ekstralar**: Otobüs/Uçak, koltuk seçimi, oda tipleri, fiyat grupları (düz/katmanlı)
- **Etkinlikler**: Konser/Tiyatro/Festival, seans yönetimi, kategori/tribün, e-bilet
- **Tatil Paketleri**: Otel/Villa/Daire, sezon fiyatlandırma, müsaitlik takvimi
- **Uçak Biletleri**: Bağımsız satış, kabin sınıfları, ek hizmetler
- **Araç Kiralama**: Araç sınıfları, sigorta paketleri, teslim/iade noktaları

### 2. Rezervasyon Sistemi
- Rezervasyon oluşturma (ödeme yok)
- Admin onay sistemi
- Ödeme linki gönderimi
- Durum yönetimi (pending → approved → payment_pending → confirmed)

### 3. Ödeme Sistemi
- Stripe (kredi kartı)
- Havale/EFT (Kolay Kod ile eşleştirme)
- Taksitli ödeme
- Ödeme linki oluşturma

### 4. Çok Markalı Yapı
- Avusturya Gezi
- Günübirlik Avrupa
- Viyana Reisen
- Avrupa'dan Dubai
- Avrupa'dan Umre
- Marka bazlı görünürlük kuralları

### 5. Paneller
- **Tek Yönetim Paneli**: Tüm markalar, rezervasyon konsolu, finans yönetimi
- **Müşteri Paneli**: Rezervasyonlar, ödemeler, belgeler, mesajlaşma
- **Acente Paneli**: B2B, komisyon yönetimi, read-only/Yetkili modlar
- **Rehber & Görevli Paneli**: Check-in, odalama, katılımcı listesi

### 6. Ek Özellikler
- Anket & Geri Bildirim
- Hediye Çeki Sistemi
- Kupon Sistemi
- Chatbot ile Rezervasyon
- İş Sürekliliği (Degraded Mode)

## 🏛️ Mimari Yaklaşım

### Domain-Driven Design (DDD)

```
app/
├── Domain/                          # Business Logic Layer
│   ├── Brands/                      # Marka Domain
│   │   ├── Models/
│   │   ├── Repositories/
│   │   └── Services/
│   ├── Tours/                       # Tur Domain
│   │   ├── Models/
│   │   │   ├── Tour.php
│   │   │   ├── TourDate.php
│   │   │   ├── TourCategory.php
│   │   │   └── PickupPoint.php
│   │   ├── Repositories/
│   │   │   └── TourRepository.php
│   │   └── Services/
│   │       └── TourService.php
│   ├── Events/                      # Etkinlik Domain
│   ├── VacationPackages/            # Tatil Domain
│   ├── FlightTickets/               # Uçak Bileti Domain
│   ├── CarRentals/                  # Araç Kiralama Domain
│   ├── Reservations/                 # Rezervasyon Domain
│   │   ├── Models/
│   │   │   ├── Reservation.php
│   │   │   ├── Guest.php
│   │   │   ├── Room.php
│   │   │   └── ReservationStatus.php
│   │   ├── Repositories/
│   │   │   └── ReservationRepository.php
│   │   ├── Services/
│   │   │   ├── ReservationService.php
│   │   │   ├── ApprovalService.php
│   │   │   └── PricingService.php
│   │   └── Events/
│   │       ├── ReservationCreated.php
│   │       ├── ReservationApproved.php
│   │       └── ReservationCancelled.php
│   ├── Payments/                    # Ödeme Domain
│   │   ├── Models/
│   │   │   ├── Payment.php
│   │   │   ├── PaymentPlan.php
│   │   │   └── PaymentLink.php
│   │   ├── Services/
│   │   │   ├── PaymentService.php
│   │   │   ├── StripeService.php
│   │   │   └── PaymentLinkService.php
│   │   └── Events/
│   │       └── PaymentCompleted.php
│   ├── Documents/                   # Belge Domain
│   │   ├── Services/
│   │   │   ├── PDFService.php
│   │   │   ├── QRCodeService.php
│   │   │   └── DocumentService.php
│   ├── Coupons/                     # Kupon Domain
│   ├── GiftCards/                   # Hediye Çeki Domain
│   ├── Surveys/                     # Anket Domain
│   └── Chatbot/                     # Chatbot Domain
├── Application/                      # Application Layer (Use Cases)
│   ├── Tours/
│   │   ├── CreateTourUseCase.php
│   │   ├── UpdateTourUseCase.php
│   │   └── GetTourAvailabilityUseCase.php
│   ├── Reservations/
│   │   ├── CreateReservationUseCase.php
│   │   ├── ApproveReservationUseCase.php
│   │   └── CancelReservationUseCase.php
│   └── Payments/
│       ├── CreatePaymentLinkUseCase.php
│       └── ProcessPaymentUseCase.php
├── Infrastructure/                   # Infrastructure Layer
│   ├── Payment/
│   │   ├── StripeGateway.php
│   │   └── BankTransferGateway.php
│   ├── Email/
│   │   └── EmailService.php
│   ├── Storage/
│   │   └── FileStorageService.php
│   └── External/
│       └── ChatbotService.php
└── Presentation/                     # Presentation Layer (API)
    ├── Http/
    │   ├── Controllers/
    │   │   ├── API/
    │   │   │   ├── Tours/
    │   │   │   │   └── TourController.php
    │   │   │   ├── Reservations/
    │   │   │   │   └── ReservationController.php
    │   │   │   └── Payments/
    │   │   │       └── PaymentController.php
    │   │   └── Admin/
    │   │       └── ReservationManagementController.php
    │   ├── Requests/
    │   │   ├── CreateReservationRequest.php
    │   │   └── ApproveReservationRequest.php
    │   └── Resources/
    │       ├── TourResource.php
    │       └── ReservationResource.php
    └── Events/
        └── Listeners/
            ├── SendReservationConfirmation.php
            └── SendPaymentLink.php
```

## 🗄️ Veritabanı Şeması

### Core Tables

```sql
-- Markalar
brands
  id, name, slug, logo, domain, settings (JSON)

-- Turlar
tours
  id, brand_id, code, title, subtitle, type (bus/flight/event)
  nights, image, itinerary (JSON), pickup_points (JSON)
  price_group_mode (düz/katmanlı), visibility_rules (JSON)

-- Tur Tarihleri
tour_dates
  id, tour_id, start_date, end_date, price, occupancy
  status (available/limited/full), single_supplement_price

-- Katılım Noktaları
pickup_points
  id, brand_id, city, location, address, time, price_modifier

-- Rezervasyonlar
reservations
  id, brand_id, user_id, tour_id, tour_date_id
  reservation_code, easy_code (AVST-XXXXXX)
  status (pending/awaiting_approval/approved/payment_pending/...)
  total_price, paid_amount, remaining_amount
  flight_preference, flight_type, airline
  payment_type (full/installment), cancellation_policy
  contact_info (JSON), created_at, approved_at, approved_by

-- Misafirler
guests
  id, reservation_id, room_id, type (adult/student/child/baby)
  first_name, last_name, gender, dob, citizenship
  pickup_point_id, seat_number, extra_seat_number
  selected_extras (JSON), notes, security_notes

-- Odalar
rooms
  id, reservation_id, room_type (single/double/twin/triple)
  adults, students, children, babies, hotel_type (4-star/5-star)

-- Ödemeler
payments
  id, reservation_id, user_id, payment_method (stripe/bank_transfer)
  amount, status (pending/completed/failed/refunded)
  stripe_payment_intent_id, stripe_payment_link_id
  easy_code, bank_transfer_reference
  paid_at, created_at

-- Ödeme Planları (Taksitler)
payment_plans
  id, payment_id, reservation_id, amount, due_date
  status (pending/completed/overdue), paid_at

-- Belgeler
documents
  id, reservation_id, type (boarding-pass/voucher/program/invoice)
  file_path, qr_code, generated_at

-- Kuponlar
coupons
  id, code, discount_type (percentage/fixed), discount_value
  min_amount, max_uses, used_count, valid_from, valid_to
  applicable_brands (JSON), applicable_products (JSON)

-- Hediye Çekleri
gift_cards
  id, code, qr_code, amount, balance, status (active/used/expired)
  purchased_by, recipient_email, recipient_name
  valid_until, used_at

-- Anketler
surveys
  id, reservation_id, type (tour/event/vacation)
  nps_score, csat_score, feedback (JSON), submitted_at
```

## 🔄 İş Akışları

### Rezervasyon Akışı

```
1. Müşteri rezervasyon oluşturur (POST /api/reservations)
   → Status: 'pending'
   → Event: ReservationCreated
   → Listener: SendReservationReceivedEmail

2. Admin rezervasyonu görür (GET /api/admin/reservations/pending)
   → Filtreleme, arama, toplu işlemler

3. Admin onaylar (POST /api/admin/reservations/{id}/approve)
   → Status: 'approved' → 'payment_pending'
   → Event: ReservationApproved
   → Listener: CreatePaymentLink, SendPaymentLinkEmail

4. Müşteri ödeme yapar
   a) Stripe Payment Link → Webhook → PaymentCompleted
   b) Panelden ödeme → PaymentController → PaymentCompleted
   c) Havale/EFT → Manuel eşleştirme → PaymentCompleted

5. Ödeme tamamlandığında
   → Status: 'payment_completed'
   → Event: PaymentCompleted
   → Listener: GenerateDocuments, SendDocumentsEmail

6. Belgeler oluşturulur
   → PDF (biniş kartı, voucher, program)
   → QR kod
   → E-posta gönderilir
```

### Ödeme Akışı

```
1. Ödeme linki oluşturma
   → Stripe Payment Link API
   → Link veritabanına kaydedilir
   → E-posta gönderilir

2. Stripe ödeme
   → Webhook: payment_intent.succeeded
   → Payment kaydı oluşturulur
   → Reservation güncellenir

3. Havale/EFT
   → Kolay Kod ile eşleştirme
   → Manuel onay (admin)
   → Payment kaydı oluşturulur
```

## 🔐 Güvenlik

### Authentication & Authorization
- Laravel Sanctum (Token-based)
- Role-based access control (RBAC)
- Permission-based (fine-grained)
- Multi-tenant isolation

### Data Protection
- Encryption at rest (sensitive data)
- HTTPS only
- SQL injection protection (Eloquent)
- XSS protection
- CSRF protection

### KVKK Compliance
- Personal data encryption
- Right to be forgotten
- Data export
- Audit trail (tüm değişiklikler loglanır)

## 📊 Performans

### Caching Strategy
- Redis cache (tours, availability)
- Database query cache
- CDN (static files, images)

### Database Optimization
- Strategic indexes
- Query optimization
- Connection pooling
- Read replicas (future)

### Queue System
- Laravel Horizon
- Background jobs (email, PDF generation)
- Failed job handling

## 🧪 Test Stratejisi

### Unit Tests
- Domain services
- Business logic
- Model relationships

### Feature Tests
- API endpoints
- Reservation flow
- Payment flow

### Integration Tests
- Full reservation → approval → payment → documents flow
- Multi-tenant scenarios

## 📈 Monitoring

### Error Tracking
- Sentry (production)
- Laravel Telescope (development)
- Log files

### Performance Monitoring
- Query logging
- Slow query detection
- API response time
- Queue job monitoring

## 🚀 Deployment

### CI/CD Pipeline
- Git push → Tests → Deploy
- Staging environment
- Production deployment

### Backup Strategy
- Daily database backup
- File backup
- Disaster recovery plan

## 📦 Paketler

```json
{
  "laravel/sanctum": "^4.0",
  "laravel/cashier": "^15.0",
  "spatie/laravel-permission": "^6.0",
  "spatie/laravel-multitenancy": "^3.0",
  "spatie/laravel-media-library": "^11.0",
  "barryvdh/laravel-dompdf": "^3.0",
  "simplesoftwareio/simple-qrcode": "^4.2",
  "stripe/stripe-php": "^13.0",
  "laravel/horizon": "^5.0",
  "laravel/telescope": "^5.0"
}
```

## 🎯 Geliştirme Öncelikleri

1. **Core Infrastructure** (Faz 1)
   - Laravel setup
   - Multi-tenancy
   - Authentication
   - Database schema

2. **Tours Module** (Faz 2)
   - Tour CRUD
   - Tour dates
   - Pricing engine
   - Availability management

3. **Reservations Module** (Faz 3)
   - Reservation creation
   - Approval system
   - Status management
   - Guest/Room management

4. **Payments Module** (Faz 4)
   - Stripe integration
   - Payment links
   - Bank transfer
   - Installment plans

5. **Documents Module** (Faz 5)
   - PDF generation
   - QR codes
   - Email sending

6. **Panels** (Faz 6)
   - Admin panel
   - Customer panel
   - Agent panel
   - Guide panel

7. **Additional Features** (Faz 7)
   - Coupons
   - Gift cards
   - Surveys
   - Chatbot

8. **Testing & Optimization** (Faz 8)
   - Test coverage
   - Performance optimization
   - Security audit
