# Backend Kurulum Durumu

## ⚠️ ÖNEMLİ: Manuel Kurulum Gerekli

Backend kurulumu için aşağıdaki yazılımların kurulu olması gerekiyor:

1. **Homebrew** (macOS paket yöneticisi)
2. **PHP 8.2** (Laravel için)
3. **Composer** (PHP bağımlılık yöneticisi)
4. **MySQL** (Veritabanı)

Bu yazılımların kurulumu için **sudo** yetkisi ve **interaktif onay** gerekiyor. Bu nedenle otomatik kurulum yapılamıyor.

## 📋 Kurulum Adımları

### 1. Homebrew Kurulumu
Terminal'de şu komutu çalıştırın:
```bash
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

### 2. PHP Kurulumu
```bash
brew install php@8.2
brew link php@8.2 --overwrite
```

### 3. Composer Kurulumu
```bash
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer
sudo chmod +x /usr/local/bin/composer
```

### 4. MySQL Kurulumu
```bash
brew install mysql
brew services start mysql
```

### 5. Veritabanı Oluşturma
```bash
mysql -u root -e "CREATE DATABASE avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
```

### 6. Backend Kurulumu
```bash
cd "/Users/denizyildiz/Desktop/avusturya gezi yeni/backend"
composer install
php artisan key:generate
php artisan migrate
php artisan db:seed
```

### 7. Backend Server'ı Başlatma
```bash
php artisan serve
```

## 🎯 Alternatif: Docker Kullanımı

Eğer Docker kuruluysa, Docker ile kurulum yapılabilir. Docker Compose dosyası hazırlanabilir.

## 📝 Notlar

- Tüm komutlar terminal'de çalıştırılmalıdır
- Bazı komutlar şifre isteyebilir (sudo için)
- Kurulum süresi yaklaşık 10-15 dakika sürebilir
- İnternet bağlantısı gereklidir
