# Avusturya Gezi - Laravel API Backend

## 🚀 Proje Hakkında

Bu proje, Avusturya Gezi turizm platformu için API-first yaklaşımla geliştirilmiş Laravel backend'idir. 
Mobil uygulama ve web frontend'i için RESTful API sağlar.

## 📋 Gereksinimler

- PHP >= 8.2
- Composer
- MySQL >= 8.0 veya PostgreSQL >= 13
- Redis (opsiyonel, cache için)
- Node.js & NPM (frontend build için)

## 🛠️ Kurulum

### 1. PHP ve Composer Kurulumu (macOS)

```bash
# Homebrew ile PHP kurulumu
brew install php

# Composer kurulumu
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer
```

### 2. Laravel Projesi Oluşturma

```bash
cd backend
composer create-project laravel/laravel . --prefer-dist
```

### 3. Gerekli Paketlerin Kurulumu

```bash
composer require laravel/sanctum
composer require laravel/cashier
composer require spatie/laravel-permission
composer require spatie/laravel-multitenancy
composer require spatie/laravel-media-library
composer require barryvdh/laravel-dompdf
composer require simplesoftwareio/simple-qrcode
composer require stripe/stripe-php
```

### 4. Environment Dosyası

`.env` dosyasını oluşturun ve yapılandırın:

```env
APP_NAME="Avusturya Gezi API"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=avusturya_gezi
DB_USERNAME=root
DB_PASSWORD=

STRIPE_KEY=
STRIPE_SECRET=
STRIPE_WEBHOOK_SECRET=

FRONTEND_URL=http://localhost:3000
```

### 5. Veritabanı ve Migration

```bash
php artisan key:generate
php artisan migrate
php artisan db:seed
```

## 📁 Proje Yapısı

```
backend/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── API/
│   │   │   │   ├── AuthController.php
│   │   │   │   ├── TourController.php
│   │   │   │   ├── ReservationController.php
│   │   │   │   ├── PaymentController.php
│   │   │   │   └── ...
│   │   │   └── Admin/
│   │   ├── Middleware/
│   │   └── Requests/
│   ├── Models/
│   ├── Services/
│   └── ...
├── database/
│   ├── migrations/
│   └── seeders/
├── routes/
│   └── api.php
└── ...
```

## 🔐 API Authentication

API, Laravel Sanctum ile token-based authentication kullanır.

### Token Alma

```bash
POST /api/auth/login
{
  "email": "user@example.com",
  "password": "password"
}
```

### Token ile İstek

```bash
Authorization: Bearer {token}
```

## 📚 API Endpoints

### Authentication
- `POST /api/auth/register` - Kayıt
- `POST /api/auth/login` - Giriş
- `POST /api/auth/logout` - Çıkış
- `GET /api/auth/user` - Kullanıcı bilgisi

### Tours
- `GET /api/tours` - Tur listesi
- `GET /api/tours/{id}` - Tur detayı
- `GET /api/tours/{id}/dates` - Tur tarihleri

### Reservations
- `POST /api/reservations` - Rezervasyon oluştur
- `GET /api/reservations` - Rezervasyonlarım
- `GET /api/reservations/{id}` - Rezervasyon detayı
- `PATCH /api/reservations/{id}/cancel` - İptal et

### Payments
- `POST /api/payments/create-link` - Ödeme linki oluştur
- `POST /api/payments/checkout` - Ödeme yap
- `GET /api/payments/{id}/status` - Ödeme durumu

## 🧪 Test

```bash
php artisan test
```

## 📝 Notlar

- API-first yaklaşım: Tüm endpoint'ler JSON response döner
- CORS yapılandırması: Frontend URL'i `.env`'de tanımlı
- Rate limiting: API endpoint'leri için aktif
- Logging: Tüm API istekleri loglanır
