<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Activity;
use App\Models\ActivityDate;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class ActivityDateController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $activityId): JsonResponse
    {
        $activity = Activity::findOrFail($activityId);

        $validated = $request->validate([
            'date' => 'required|date',
            'start_time' => 'required',
            'adult_price' => 'required|numeric|min:0',
            'child_price' => 'nullable|numeric|min:0',
            'infant_price' => 'nullable|numeric|min:0',
            'capacity' => 'required|integer|min:1',
            'is_active' => 'boolean',
            'pricing_data' => 'nullable|array' // Added
        ]);

        if (!isset($validated['child_price'])) $validated['child_price'] = $validated['adult_price'];
        if (!isset($validated['infant_price'])) $validated['infant_price'] = 0;

        $date = $activity->dates()->create($validated);

        return response()->json([
            'message' => 'Date added successfully',
            'data' => $date
        ], 201);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $activityId, $id): JsonResponse
    {
        $date = ActivityDate::where('activity_id', $activityId)->findOrFail($id);

        $validated = $request->validate([
            'date' => 'date',
            'start_time' => 'string',
            'adult_price' => 'numeric|min:0',
            'child_price' => 'nullable|numeric|min:0',
            'infant_price' => 'nullable|numeric|min:0',
            'capacity' => 'integer|min:1',
            'is_active' => 'boolean',
            'pricing_data' => 'nullable|array' // Added
        ]);

        $date->update($validated);

        return response()->json([
            'message' => 'Date updated successfully',
            'data' => $date
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($activityId, $id): JsonResponse
    {
        $date = ActivityDate::where('activity_id', $activityId)->findOrFail($id);
        $date->delete();

        return response()->json([
            'message' => 'Date deleted successfully'
        ]);
    }
}
