<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BankAccount;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class BankAccountController extends Controller
{
    /**
     * Get all bank accounts
     */
    public function index(Request $request): JsonResponse
    {
        $query = BankAccount::where('is_active', true);
        
        $accounts = $query->orderBy('order', 'asc')
            ->orderBy('id', 'asc')
            ->get();

        return response()->json($accounts);
    }
}
