<?php

namespace App\Http\Controllers\Api\Villa;

use App\Http\Controllers\Controller;
use App\Models\Villa;
use Illuminate\Http\Request;

class VillaController extends Controller
{
    public function index()
    {
        $villas = Villa::orderBy('created_at', 'desc')->get();
        return response()->json(['data' => $villas]);
    }

    public function show($id)
    {
        if (is_numeric($id)) {
            $villa = Villa::findOrFail($id);
        } else {
            $villa = Villa::where('slug', $id)->firstOrFail();
        }
        return response()->json(['data' => $villa]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|array',
            'slug' => 'required|string|unique:villas',
            'price' => 'required|numeric',
            'discounted_price' => 'nullable|numeric',
            'location' => 'nullable|string',
            'capacity_adults' => 'integer',
            'capacity_children' => 'integer',
            'bedrooms' => 'integer',
            'bathrooms' => 'integer',
            'pool_type' => 'nullable|string',
            'checkin_time' => 'nullable|string',
            'checkout_time' => 'nullable|string',
            'description' => 'nullable|array',
            'highlights' => 'nullable|array',
            'amenities' => 'nullable|array',
            'gallery' => 'nullable|array',
            'faqs' => 'nullable|array',
            'distances' => 'nullable|array',
            'is_active' => 'boolean',
            'brand_ids' => 'nullable|array',
            'agent_group_ids' => 'nullable|array'
        ]);

        $villa = Villa::create($validated);
        return response()->json($villa, 201);
    }

    public function update(Request $request, $id)
    {
        $villa = Villa::findOrFail($id);
        $validated = $request->validate([
            'title' => 'array',
            'slug' => 'string|unique:villas,slug,' . $id,
            'price' => 'numeric',
            'discounted_price' => 'nullable|numeric',
            'location' => 'nullable|string',
            'capacity_adults' => 'integer',
            'capacity_children' => 'integer',
            'bedrooms' => 'integer',
            'bathrooms' => 'integer',
            'pool_type' => 'nullable|string',
            'checkin_time' => 'nullable|string',
            'checkout_time' => 'nullable|string',
            'description' => 'nullable|array',
            'highlights' => 'nullable|array',
            'amenities' => 'nullable|array',
            'gallery' => 'nullable|array',
            'faqs' => 'nullable|array',
            'distances' => 'nullable|array',
            'is_active' => 'boolean',
            'brand_ids' => 'nullable|array',
            'agent_group_ids' => 'nullable|array'
        ]);

        $villa->update($validated);
        return response()->json($villa);
    }

    public function destroy($id)
    {
        Villa::findOrFail($id)->delete();
        return response()->noContent();
    }
}
