<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureUserIsAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return response()->json([
                'message' => 'Unauthenticated',
                'error' => 'You must be logged in to access this resource'
            ], 401);
        }

        // Admin veya super_admin kullanıcılarına izin ver
        $allowedTypes = ['admin', 'super_admin'];
        
        if (!in_array($user->user_type, $allowedTypes)) {
            return response()->json([
                'message' => 'Forbidden',
                'error' => 'You do not have permission to access this resource'
            ], 403);
        }

        if (!$user->is_active) {
            return response()->json([
                'message' => 'Account Deactivated',
                'error' => 'Your account has been deactivated'
            ], 403);
        }

        return $next($request);
    }
}
