<?php

namespace App\Mail;

use App\Models\Reservation;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ReservationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Reservation $reservation,
        public string $type, // 'approval' | 'payment_reminder' | 'generic'
        public ?string $customSubject = null,
        public ?string $customBody = null
    ) {}

    public function envelope(): Envelope
    {
        $subject = $this->customSubject ?? match ($this->type) {
            'approval' => 'Rezervasyon Onayı - ' . ($this->reservation->easy_code ?? $this->reservation->reservation_code),
            'payment_reminder' => 'Ödeme Hatırlatması - ' . ($this->reservation->easy_code ?? $this->reservation->reservation_code),
            default => 'Rezervasyon Bilgisi - ' . ($this->reservation->easy_code ?? $this->reservation->reservation_code),
        };
        $fromAddr = config('mail.from.address', 'noreply@avusturyagezi.com');
        $fromName = config('mail.from.name', 'Avusturya Gezi');
        $replyAddr = config('mail.from.address', 'info@avusturyagezi.com');
        return new Envelope(
            subject: $subject,
            from: new Address($fromAddr, $fromName),
            replyTo: [new Address($replyAddr, $fromName)],
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.reservation',
        );
    }
}
