<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Activity extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'slug',
        'subtitle',
        'description',
        'images',
        'highlights',
        'included',
        'excluded',
        'important_notes',
        'duration',
        'location',
        'base_price',
        'base_price',
        'cancellation_policy',
        'default_start_time',
        'is_active',
        'order',
    ];

    protected $casts = [
        'images' => 'array',
        'highlights' => 'array',
        'included' => 'array',
        'excluded' => 'array',
        'important_notes' => 'array',
        'is_active' => 'boolean',
        'base_price' => 'decimal:2',
    ];

    public function dates()
    {
        return $this->hasMany(ActivityDate::class);
    }

    public function pricingTiers()
    {
        return $this->hasMany(ActivityPricingTier::class);
    }
}
