<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ActivityDate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'activity_id',
        'date',
        'start_time',
        'adult_price',
        'child_price',
        'infant_price',
        'capacity',
        'booked',
        'booked',
        'is_active',
        'pricing_data',
    ];

    protected $casts = [
        'date' => 'date',
        // 'start_time' => 'datetime:H:i', // Optional casting
        'adult_price' => 'decimal:2',
        'child_price' => 'decimal:2',
        'infant_price' => 'decimal:2',
        'pricing_data' => 'array',
        'is_active' => 'boolean',
    ];

    public function activity()
    {
        return $this->belongsTo(Activity::class);
    }
}
