<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivityPricingTier extends Model
{
    use HasFactory;

    protected $fillable = [
        'activity_id',
        'name',
        'price',
        'min_age',
        'max_age',
    ];

    protected $casts = [
        'price' => 'decimal:2',
    ];

    public function activity()
    {
        return $this->belongsTo(Activity::class);
    }
}
