<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AgentGroup extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'commission_rate',
        'access_rules',
        'mode',
        'is_active',
    ];

    protected $casts = [
        'commission_rate' => 'decimal:2',
        'access_rules' => 'array',
        'is_active' => 'boolean',
    ];

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
