<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Brand extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'slug',
        'logo',
        'domain',
        'api_key',
        'settings',
        'is_active',
    ];

    protected $casts = [
        'settings' => 'array',
        'is_active' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();

        // API key otomatik oluştur
        static::creating(function ($brand) {
            if (empty($brand->api_key)) {
                $brand->api_key = 'br_' . Str::random(32);
            }
        });
    }

    public function tours()
    {
        return $this->hasMany(Tour::class);
    }

    public function pickupPoints()
    {
        return $this->hasMany(PickupPoint::class);
    }

    public function stories()
    {
        return $this->belongsToMany(Story::class, 'brand_story');
    }

    public function testimonials()
    {
        return $this->belongsToMany(Testimonial::class, 'brand_testimonial');
    }

    /**
     * Get reservation code prefix for this brand
     */
    public function getReservationPrefix(): string
    {
        return match($this->slug) {
            'avusturya-gezi' => 'AVG',
            'avrupadan-dubai' => 'AVD',
            'avrupadan-umre' => 'AVU',
            'gunubirlik-avrupa' => 'GAV',
            'viyana-reisen' => 'VR',
            default => 'AVG',
        };
    }
}
