<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ErrorLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'source',
        'endpoint',
        'method',
        'error_type',
        'error_message',
        'error_details',
        'stack_trace',
        'request_data',
        'user_id',
        'ip_address',
        'user_agent',
        'status_code',
        'resolved',
        'resolved_at',
        'resolved_by',
        'notes',
    ];

    protected $casts = [
        'error_details' => 'array',
        'request_data' => 'array',
        'resolved' => 'boolean',
        'resolved_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function resolver()
    {
        return $this->belongsTo(User::class, 'resolved_by');
    }
}
