<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'reservation_id',
        'invoice_no',
        'invoice_date',
        'total_price',
        'discount_amount',
        'tax_amount',
        'status',
        'billing_details',
        'items',
        'notes',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'total_price' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'billing_details' => 'array',
        'items' => 'array',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }
}
