<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Page extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'slug',
        'title',
        'template',
        'sections',
        'seo',
        'published',
        'brand_id',
        'order',
    ];

    protected $casts = [
        'sections' => 'array',
        'seo' => 'array',
        'published' => 'boolean',
    ];

    /**
     * Get the brand that owns the page.
     */
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    /**
     * Scope a query to only include published pages.
     */
    public function scopePublished($query)
    {
        return $query->where('published', true);
    }

    /**
     * Scope a query to filter by brand.
     */
    public function scopeForBrand($query, $brandId)
    {
        return $query->where(function ($q) use ($brandId) {
            $q->where('brand_id', $brandId)
              ->orWhereNull('brand_id'); // Global pages
        });
    }
}
