<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PickupPoint extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'brand_id',
        'city',
        'location',
        'address',
        'latitude',
        'longitude',
        'default_time',
        'price_modifier',
        'is_active',
        'order',
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'price_modifier' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function guests()
    {
        return $this->hasMany(Guest::class);
    }
}
