<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

    protected $fillable = [
        'reservation_id',
        'room_type',
        'adults',
        'students',
        'children',
        'babies',
        'hotel_type',
        'hotel_name',
        'room_number',
        'notes',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }

    public function guests()
    {
        return $this->hasMany(Guest::class);
    }

    public function getTotalGuestsAttribute()
    {
        return $this->adults + $this->students + $this->children + $this->babies;
    }
}
