<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tour extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'brand_id',
        'code',
        'title',
        'subtitle',
        'seo_title',
        'slug',
        'seo_description',
        'seo_image',
        'departure_point',
        'type',
        'nights',
        'description',
        'itinerary',
        'image',
        'images',
        'price',
        'discounted_price',
        'highlights',
        'included',
        'excluded',
        'price_group_mode',
        'visibility_rules',
        'transport_types',
        'guide_id',
        'assistant_id',
        'pickup_points',
        'bank_account_id',
        'bank_account_ids',
        'airline_id',
        'terms_ids',
        'countries',
        'is_active',
        'order',
        'flight_options',
        'room_options',
        'hotel_options',
        'feature_cards',
        'label',
        'extra_services',
        'merchandise_items',
        'cancellation_insurance',
        'bus_seat_layout',
        'gyg_product_id',
        'gyg_is_active',
    ];

    protected $casts = [
        'title' => 'array',
        'subtitle' => 'array',
        'seo_title' => 'array',
        'description' => 'array',
        'itinerary' => 'array',
        'images' => 'array',
        'highlights' => 'array',
        'included' => 'array',
        'excluded' => 'array',
        'departure_point' => 'array',
        'visibility_rules' => 'array',
        'transport_types' => 'array',
        'pickup_points' => 'array',
        'countries' => 'array',
        'terms_ids' => 'array',
        'bank_account_ids' => 'array',
        'flight_options' => 'array',
        'room_options' => 'array',
        'hotel_options' => 'array',
        'feature_cards' => 'array',
        'label' => 'array',
        'extra_services' => 'array',
        'merchandise_items' => 'array',
        'cancellation_insurance' => 'array',
        'bus_seat_layout' => 'array',
        'is_active' => 'boolean',
        'gyg_is_active' => 'boolean',
        'price' => 'decimal:2',
        'discounted_price' => 'decimal:2',
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function dates()
    {
        return $this->hasMany(TourDate::class);
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function categories()
    {
        return $this->belongsToMany(TourCategory::class, 'tour_category_tour');
    }

    public function guide()
    {
        return $this->belongsTo(User::class, 'guide_id');
    }

    public function assistant()
    {
        return $this->belongsTo(User::class, 'assistant_id');
    }
}
