<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TourCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'description',
        'icon',
        'parent_id',
        'order',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function parent()
    {
        return $this->belongsTo(TourCategory::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(TourCategory::class, 'parent_id');
    }

    public function tours()
    {
        return $this->belongsToMany(Tour::class, 'tour_category_tour');
    }
}
