<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TourDate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'tour_id',
        'start_date',
        'end_date',
        'start_time',
        'end_time',
        'adult_price',
        'adult_discounted_price',
        'child_price',
        'child_discounted_price',
        'baby_price',
        'baby_discounted_price',
        'capacity',
        'booked',
        'status',
        'single_supplement_price',
        'pickup_point_prices',
        'transportation', // Ulaşım bilgileri (uçak, otobüs, gemi vb.)
        'hotel_options', // Tarih bazlı otel seçenekleri
        'bus_layout', // Koltuk düzeni ve detayları
        'meal_list', // Yemek listesi (legacy, tek liste)
        'meal_options', // Yemek kategorileri: { categories: [ { key, label, options[] } ] }
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'adult_price' => 'decimal:2',
        'adult_discounted_price' => 'decimal:2',
        'child_price' => 'decimal:2',
        'child_discounted_price' => 'decimal:2',
        'baby_price' => 'decimal:2',
        'baby_discounted_price' => 'decimal:2',
        'single_supplement_price' => 'decimal:2',
        'pickup_point_prices' => 'array',
        'transportation' => 'array', // JSON olarak saklanacak
        'hotel_options' => 'array', // JSON olarak saklanacak
        'bus_layout' => 'array', // JSON olarak saklanacak
        'meal_list' => 'array',
        'meal_options' => 'array', // { categories: [ { key, label, options[] } ] }
    ];

    public function tour()
    {
        return $this->belongsTo(Tour::class);
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function getAvailableSpotsAttribute()
    {
        return max(0, $this->capacity - $this->booked);
    }

    public function getOccupancyPercentageAttribute()
    {
        if ($this->capacity == 0) return 0;
        return ($this->booked / $this->capacity) * 100;
    }
}
