<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasRoles, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'address',
        'city',
        'zip_code',
        'country',
        'date_of_birth',
        'gender',
        'citizenship',
        'loyalty_points',
        'user_type',
        'agent_group_id',
        'is_active',
        'email_verified_at',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'date_of_birth' => 'date',
        'loyalty_points' => 'integer',
        'is_active' => 'boolean',
        'password' => 'hashed',
    ];

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }

    public function agentGroup()
    {
        return $this->belongsTo(AgentGroup::class);
    }

    public function isAdmin()
    {
        return in_array($this->user_type, ['admin', 'super_admin']);
    }

    public function isAgent()
    {
        return $this->user_type === 'agent';
    }

    public function isGuide()
    {
        return $this->user_type === 'guide';
    }
}
