<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Villa extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'slug',
        'price',
        'discounted_price',
        'location',
        'capacity_adults',
        'capacity_children',
        'bedrooms',
        'bathrooms',
        'area_sqm',
        'min_stay',
        'damage_deposit',
        'cleaning_fee',
        'pool_type',
        'checkin_time',
        'checkout_time',
        'description',
        'highlights',
        'amenities',
        'house_rules',
        'property_type_tags',
        'gallery',
        'faqs',
        'distances',
        'is_active',
        'brand_ids',
        'agent_group_ids'
    ];

    protected $casts = [
        'title' => 'array',
        'description' => 'array',
        'highlights' => 'array',
        'amenities' => 'array',
        'house_rules' => 'array',
        'property_type_tags' => 'array',
        'gallery' => 'array',
        'faqs' => 'array',
        'distances' => 'array',
        'brand_ids' => 'array',
        'agent_group_ids' => 'array',
        'price' => 'decimal:2',
        'discounted_price' => 'decimal:2',
        'damage_deposit' => 'decimal:2',
        'cleaning_fee' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}
