<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisaApplication extends Model
{
    use HasFactory;

    protected $fillable = [
        'visa_id',
        'contact_info',
        'documents',
        'status',
        'payment_status',
        'notes'
    ];

    protected $casts = [
        'contact_info' => 'array',
        'documents' => 'array'
    ];

    public function visa()
    {
        return $this->belongsTo(Visa::class);
    }
}
