// Get latest 15 reservations that have rooms
$reservations = App\Models\Reservation::with('rooms')
    ->whereHas('rooms')
    ->orderBy('created_at', 'desc')
    ->take(15)
    ->get();

$hotels = [
    'Novotel Vienna City',
    'Ibis Budget Wien', 
    'Hilton Danube',
    'Mercure Grand Hotel'
];

$count = 0;
foreach ($reservations as $index => $res) {
    // Pick a hotel based on index
    $hotel = $hotels[$index % count($hotels)];
    
    foreach ($res->rooms as $room) {
        $room->hotel_type = $hotel;
        $room->save();
    }
    
    echo "Updated Reservation #{$res->id} ({$res->reservation_code}) -> {$hotel}\n";
    $count++;
}

echo "Done! Updated {$count} reservations.\n";
