<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tours', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->string('code')->unique();
            $table->string('title');
            $table->string('subtitle')->nullable();
            $table->enum('type', ['bus', 'flight', 'event', 'vacation', 'car_rental'])->default('bus');
            $table->integer('nights')->default(0);
            $table->text('description')->nullable();
            $table->text('itinerary')->nullable(); // JSON veya text
            $table->json('images')->nullable();
            $table->json('highlights')->nullable();
            $table->json('included')->nullable();
            $table->json('excluded')->nullable();
            $table->enum('price_group_mode', ['simple', 'layered'])->default('simple');
            $table->json('visibility_rules')->nullable(); // Hangi markalarda görünecek, hangi acente gruplarına açık
            $table->json('transport_types')->nullable(); // [bus, flight, train]
            $table->unsignedBigInteger('guide_id')->nullable();
            $table->unsignedBigInteger('assistant_id')->nullable();
            $table->json('pickup_points')->nullable(); // İlişkili pickup point ID'leri
            $table->unsignedBigInteger('bank_account_id')->nullable();
            $table->unsignedBigInteger('airline_id')->nullable();
            $table->json('terms_ids')->nullable(); // İlişkili şartlar
            $table->boolean('is_active')->default(true);
            $table->integer('order')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tours');
    }
};
