<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('guests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id')->nullable()->onDelete('cascade');
            $table->unsignedBigInteger('room_id')->nullable()->nullable()->onDelete('set null');
            $table->enum('type', ['adult', 'student', 'child', 'baby']);
            $table->string('first_name');
            $table->string('last_name');
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('citizenship')->nullable();
            $table->string('passport_number')->nullable();
            $table->date('passport_expiry')->nullable();
            $table->unsignedBigInteger('pickup_point_id')->nullable()->nullable()->onDelete('set null');
            $table->string('seat_number')->nullable(); // Otobüs koltuğu
            $table->string('extra_seat_number')->nullable(); // Ekstra koltuk
            $table->json('selected_extras')->nullable(); // Seçilen ekstra hizmetler
            $table->text('notes')->nullable();
            $table->text('security_notes')->nullable(); // Admin için
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('guests');
    }
};
