<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id')->nullable()->onDelete('cascade');
            $table->enum('room_type', ['single', 'double', 'twin', 'triple', 'quad', 'family']);
            $table->integer('adults')->default(0);
            $table->integer('students')->default(0);
            $table->integer('children')->default(0);
            $table->integer('babies')->default(0);
            $table->enum('hotel_type', ['3-star', '4-star', '5-star', 'boutique', 'villa'])->nullable();
            $table->string('room_number')->nullable(); // Otel oda numarası
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('rooms');
    }
};
