<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id')->nullable()->onDelete('cascade');
            $table->unsignedBigInteger('user_id')->nullable()->nullable()->onDelete('set null');
            $table->enum('payment_method', ['stripe', 'bank_transfer', 'cash', 'gift_card', 'coupon']);
            $table->decimal('amount', 10, 2);
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'refunded', 'cancelled'])->default('pending');
            $table->string('stripe_payment_intent_id')->nullable();
            $table->string('stripe_payment_link_id')->nullable();
            $table->string('easy_code')->nullable(); // AVST-XXXXXX (havale/EFT için)
            $table->string('bank_transfer_reference')->nullable();
            $table->text('notes')->nullable();
            $table->timestamp('paid_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
