<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id')->nullable()->onDelete('cascade');
            $table->enum('type', ['boarding_pass', 'voucher', 'program', 'invoice', 'receipt', 'contract']);
            $table->string('file_path');
            $table->string('qr_code')->nullable();
            $table->text('qr_data')->nullable(); // QR kod içeriği
            $table->timestamp('generated_at');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
