<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('agent_groups', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->decimal('commission_rate', 5, 2)->default(0); // Yüzde
            $table->json('access_rules')->nullable(); // Hangi markalara, ürünlere erişim
            $table->enum('mode', ['read_only', 'authorized'])->default('read_only');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('agent_groups');
    }
};
