<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tour_category_tour', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tour_id')->nullable()->onDelete('cascade');
            $table->unsignedBigInteger('tour_category_id')->nullable()->onDelete('cascade');
            $table->timestamps();
            
            $table->unique(['tour_id', 'tour_category_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tour_category_tour');
    }
};
