<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable()->nullable()->onDelete('set null');
            $table->unsignedBigInteger('reservation_id')->nullable()->nullable()->onDelete('cascade');
            $table->string('subject');
            $table->text('message');
            $table->enum('type', ['support', 'reservation', 'payment', 'general'])->default('support');
            $table->enum('status', ['open', 'in_progress', 'resolved', 'closed'])->default('open');
            $table->unsignedBigInteger('assigned_to')->nullable()->nullable()->onDelete('set null');
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
