<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->decimal('price', 10, 2)->nullable()->after('subtitle');
            $table->decimal('discounted_price', 10, 2)->nullable()->after('price');
            $table->string('image')->nullable()->after('discounted_price'); // Kapak görseli URL
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn(['price', 'discounted_price', 'image']);
        });
    }
};
