<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Adding 'new', 'assigned', 'replied', 'archived' to the existing enum
        // Existing: 'open','in_progress','resolved','closed'
        DB::statement("ALTER TABLE messages MODIFY COLUMN status ENUM('open', 'in_progress', 'resolved', 'closed', 'new', 'assigned', 'replied', 'archived') DEFAULT 'new'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement("ALTER TABLE messages MODIFY COLUMN status ENUM('open', 'in_progress', 'resolved', 'closed') DEFAULT 'open'");
    }
};
