<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            // Ekstra hizmetler (tur bazlı)
            // Format: [{"id": 1, "name": {"tr": "...", "en": "..."}, "description": {...}, "price": 65, "image": "url", "icon": "ship"}]
            $table->json('extra_services')->nullable()->after('label');
            
            // Mağaza ürünleri (tur bazlı)
            // Format: [{"id": 1, "name": {"tr": "...", "en": "..."}, "price": 25, "image": "url", "description": {...}}]
            $table->json('merchandise_items')->nullable()->after('extra_services');
            
            // İptal güvence seçenekleri (tur bazlı)
            // Format: {"enabled": true, "price_per_person": 20, "name": {...}, "description": {...}}
            $table->json('cancellation_insurance')->nullable()->after('merchandise_items');
            
            // Otobüs koltuk düzeni (sadece bus turları için)
            // Format: {"rows": 12, "columns": 4, "layout": "2-2", "total_seats": 48, "premium_rows": [1, 2], "premium_price": 15}
            $table->json('bus_seat_layout')->nullable()->after('cancellation_insurance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn([
                'extra_services',
                'merchandise_items',
                'cancellation_insurance',
                'bus_seat_layout'
            ]);
        });
    }
};
