<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            // Tur bazlı uçak seçenekleri (panelden düzenlenebilir)
            // Format: [{"id": 1, "name": {"tr": "...", "en": "..."}, "price": 150, "description": {...}, ...}]
            $table->json('flight_options')->nullable()->after('countries');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn('flight_options');
        });
    }
};
