<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('guests', function (Blueprint $table) {
            $table->string('departure_seat_number')->nullable()->after('extra_seat_number');
            $table->string('return_seat_number')->nullable()->after('departure_seat_number');
        });
    }

    public function down(): void
    {
        Schema::table('guests', function (Blueprint $table) {
            $table->dropColumn(['departure_seat_number', 'return_seat_number']);
        });
    }
};
