<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Change hotel_type from ENUM to VARCHAR to allow dynamic hotel names
        // Using raw SQL for maximum compatibility as doctrine/dbal might be missing
        // and changing ENUMs can be tricky
        DB::statement("ALTER TABLE rooms MODIFY hotel_type VARCHAR(255) NULL");
    }

    public function down(): void
    {
        // Reverting would require ensuring all data matches the enum values, which is risky
        // So we leave it as string or optionally try to revert if sure
    }
};
