<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('tour_dates', function (Blueprint $table) {
            $table->json('meal_options')->nullable()->after('meal_list');
        });

        Schema::table('guests', function (Blueprint $table) {
            $table->json('meal_selections')->nullable()->after('notes');
        });
    }

    public function down(): void
    {
        Schema::table('tour_dates', function (Blueprint $table) {
            $table->dropColumn('meal_options');
        });
        Schema::table('guests', function (Blueprint $table) {
            $table->dropColumn('meal_selections');
        });
    }
};
