<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visa_applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('visa_id')->constrained()->onDelete('cascade');
            $table->json('contact_info')->nullable(); // {name, surname, email, phone, address}
            $table->json('documents')->nullable(); // {passport: url, photo: url}
            $table->string('status')->default('pending'); // pending, approved, rejected
            $table->string('payment_status')->default('pending'); // pending, paid
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visa_applications');
    }
};
