<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('villas', function (Blueprint $blueprint) {
            $blueprint->integer('area_sqm')->nullable()->after('bathrooms');
            $blueprint->integer('min_stay')->default(1)->after('area_sqm');
            $blueprint->decimal('damage_deposit', 10, 2)->nullable()->after('min_stay');
            $blueprint->decimal('cleaning_fee', 10, 2)->nullable()->after('damage_deposit');
            $blueprint->json('house_rules')->nullable()->after('cleaning_fee');
            $blueprint->json('property_type_tags')->nullable()->after('house_rules');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('villas', function (Blueprint $table) {
            $table->dropColumn([
                'area_sqm',
                'min_stay',
                'damage_deposit',
                'cleaning_fee',
                'house_rules',
                'property_type_tags'
            ]);
        });
    }
};
