<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hotels', function (Blueprint $table) {
            $table->string('board_basis')->nullable()->after('location'); // Main board type for listing
            $table->string('collection_tag')->nullable()->after('board_basis'); // e.g., Premium Collection
            $table->text('summary')->nullable()->after('collection_tag'); // Short intro
            $table->json('flight_details')->nullable()->after('summary');
            $table->json('room_details')->nullable()->after('flight_details');
            $table->json('transfer_details')->nullable()->after('room_details');
            $table->json('dates')->nullable()->after('transfer_details'); // Fixed date ranges
            $table->string('video_url')->nullable()->after('dates');
            $table->json('highlights')->nullable()->after('video_url');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hotels', function (Blueprint $table) {
            $table->dropColumn([
                'board_basis',
                'collection_tag',
                'summary',
                'flight_details',
                'room_details',
                'transfer_details',
                'dates',
                'video_url',
                'highlights'
            ]);
        });
    }
};
