<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update reservation_code matching 'AVST-%'
        DB::table('reservations')
            ->where('reservation_code', 'like', 'AVST-%')
            ->update([
                'reservation_code' => DB::raw("REPLACE(reservation_code, 'AVST-', 'AVG-')")
            ]);

        // Update easy_code matching 'AVST-%'
        DB::table('reservations')
            ->where('easy_code', 'like', 'AVST-%')
            ->update([
                'easy_code' => DB::raw("REPLACE(easy_code, 'AVST-', 'AVG-')")
            ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert AVG- to AVST- (optional, providing for safety)
        DB::table('reservations')
            ->where('reservation_code', 'like', 'AVG-%')
            ->update([
                'reservation_code' => DB::raw("REPLACE(reservation_code, 'AVG-', 'AVST-')")
            ]);

        DB::table('reservations')
            ->where('easy_code', 'like', 'AVG-%')
            ->update([
                'easy_code' => DB::raw("REPLACE(easy_code, 'AVG-', 'AVST-')")
            ]);
    }
};
