<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\FlightTicket;
use App\Models\Airline;
use App\Models\Brand;

class FlightExampleSeeder extends Seeder
{
    public function run(): void
    {
        // Get Brand ID
        $brandId = Brand::where('slug', 'viyana-reisen')->first()->id;

        // Create Airlines
        $pegasus = Airline::updateOrCreate(['code' => 'PC'], ['name' => 'Pegasus Airlines', 'is_active' => true]);
        $thy = Airline::updateOrCreate(['code' => 'TK'], ['name' => 'Turkish Airlines', 'is_active' => true]);
        $sunexpress = Airline::updateOrCreate(['code' => 'XQ'], ['name' => 'SunExpress', 'is_active' => true]);

        // Ticket 1: Viyana-Ankara Return
        FlightTicket::create([
            'airline_id' => $pegasus->id,
            'type' => 'round-trip',
            'is_direct' => true,
            'price' => 159.00,
            'currency' => 'EUR',
            'slogan' => 'UÇURAN FIRSAT!',
            'outbound_date' => '2026-02-08',
            'outbound_time' => '08:50 - 13:10',
            'outbound_departure_airport' => 'VİYANA',
            'outbound_arrival_airport' => 'ANKARA',
            'inbound_date' => '2026-02-15',
            'inbound_time' => '07:25 - 08:05',
            'inbound_departure_airport' => 'ANKARA',
            'inbound_arrival_airport' => 'VİYANA',
            'is_active' => true,
            'brand_ids' => [$brandId],
        ]);

        // Ticket 2: Viyana-Istanbul One-way
        FlightTicket::create([
            'airline_id' => $thy->id,
            'type' => 'one-way',
            'is_direct' => true,
            'price' => 49.00,
            'currency' => 'EUR',
            'slogan' => 'KAÇMAZ FİYAT!',
            'outbound_date' => '2026-01-22',
            'outbound_time' => 'Tüm Gün',
            'outbound_departure_airport' => 'VİYANA',
            'outbound_arrival_airport' => 'İSTANBUL',
            'is_active' => true,
            'brand_ids' => [$brandId],
        ]);

        // Ticket 3: Viyana-Kayseri Return (Connection)
        FlightTicket::create([
            'airline_id' => $sunexpress->id,
            'type' => 'round-trip',
            'is_direct' => false,
            'price' => 129.99,
            'currency' => 'EUR',
            'slogan' => 'AVANTAJLI UÇ!',
            'outbound_date' => '2026-02-22',
            'outbound_time' => '14:00 - 22:00',
            'outbound_departure_airport' => 'VİYANA',
            'outbound_arrival_airport' => 'KAYSERİ',
            'inbound_date' => '2026-03-02',
            'inbound_time' => '09:30 - 13:00',
            'inbound_departure_airport' => 'KAYSERİ',
            'inbound_arrival_airport' => 'VİYANA',
            'is_active' => true,
            'brand_ids' => [$brandId],
        ]);
    }
}
