<?php
// backend/public/check_api.php

require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

use App\Models\Tour;
use App\Http\Controllers\Api\Tours\TourController;
use Illuminate\Http\Request;

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$kernel->handle(Illuminate\Http\Request::capture());

echo "<pre>";
echo "<h1>API Response Debugger</h1>";

try {
    // 1. Get latest tour
    $tour = Tour::orderBy('updated_at', 'desc')->first();
    if (!$tour) {
        die("No tours found");
    }
    
    echo "<h2>Testing API for Tour: " . $tour->title['tr'] . " (ID: " . $tour->id . ")</h2>";

    // 2. Instantiate Controller
    $controller = new TourController();
    
    // 3. Call show method
    // Note: show method returns a JsonResponse
    $response = $controller->show($tour->id);
    
    // 4. Get data from response
    $data = $response->getData(true); // true = as array
    
    echo "<h3>Raw 'pickup_points' in API Response:</h3>";
    
    if (isset($data['data']['pickup_points'])) {
        $pp = $data['data']['pickup_points'];
        echo "Type: " . gettype($pp) . "\n";
        echo "Value: ";
        var_dump($pp);
        
        if (is_string($pp)) {
             echo "\n(This is a JSON string. Frontend needs to parse it.)";
             $decoded = json_decode($pp, true);
             if (json_last_error() === JSON_ERROR_NONE) {
                 echo "\nDecoded test: OK. Structure:\n";
                 print_r($decoded);
             } else {
                 echo "\nDecoded test: FAILED. Error: " . json_last_error_msg();
             }
        }
    } else {
        echo "KEY 'pickup_points' MISSING in response data!";
    }

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n" . $e->getTraceAsString();
}

echo "</pre>";
