@php
    $baseUrl = rtrim(config('app.url') ?? '', '/');
    $logoUrl = config('mail.logo_url') ?? ($baseUrl ? $baseUrl . '/images/logo.png' : null);
    $contact = $reservation->contact_info ?? [];
    $name = ($reservation->user?->name ?? null) ?? ($contact['fullName'] ?? $contact['full_name'] ?? 'Sayın Müşterimiz');
    $t = $reservation->tour;
    $tourName = $t ? (is_string($t->title ?? null) ? $t->title : (is_array($t->title) ? ($t->title['tr'] ?? $t->title['en'] ?? 'Tur') : 'Tur')) : 'Tur';
    $total = (float) $reservation->total_price;
    $paid = (float) $reservation->paid_amount;
    $remaining = (float) $reservation->remaining_amount;
    $td = $reservation->tourDate;
    $dateStr = $td && $td->start_date ? $td->start_date->format('d.m.Y') : '–';
    $timeStr = $td && $td->start_time ? (is_object($td->start_time) ? $td->start_time->format('H:i') : $td->start_time) : '–';
    $typeLabels = ['adult' => 'Yetişkin', 'student' => 'Öğrenci', 'child' => 'Çocuk', 'baby' => 'Bebek'];
@endphp
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $customSubject ?? 'Rezervasyon' }}</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; margin: 0; padding: 0; background: #f1f5f9; }
        .wrap { max-width: 620px; margin: 0 auto; padding: 24px; }
        .card { background: #fff; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,.08); overflow: hidden; }
        .header { background: linear-gradient(135deg, #0ea5e9 0%, #0369a1 100%); color: #fff; padding: 28px 24px; text-align: center; }
        .header img { max-width: 180px; height: auto; display: block; margin: 0 auto 12px; }
        .header .brand { font-size: 1.5rem; font-weight: 700; letter-spacing: .02em; }
        .title-block { background: #f8fafc; padding: 20px 24px; border-bottom: 1px solid #e2e8f0; }
        .title-block h1 { margin: 0; font-size: 1.35rem; color: #0f172a; font-weight: 700; }
        .title-block .code { font-family: monospace; font-size: 1.1rem; letter-spacing: .05em; color: #0369a1; margin-top: 6px; font-weight: 600; }
        .body { padding: 24px; color: #334155; line-height: 1.65; }
        .body p { margin: 0 0 1em; }
        .detail-section { margin-top: 20px; margin-bottom: 20px; }
        .detail-section h2 { font-size: 1.05rem; color: #0f172a; margin: 0 0 12px; padding-bottom: 8px; border-bottom: 2px solid #0ea5e9; }
        .row { display: flex; justify-content: space-between; align-items: flex-start; padding: 10px 0; border-bottom: 1px solid #e2e8f0; }
        .row:last-child { border-bottom: none; }
        .label { color: #64748b; font-size: .9em; min-width: 120px; }
        .value { font-weight: 600; color: #0f172a; text-align: right; }
        .guests-list { margin: 0; padding-left: 18px; }
        .guests-list li { margin-bottom: 4px; color: #334155; }
        .foot { background: #f1f5f9; padding: 20px 24px; text-align: center; font-size: .85em; color: #64748b; border-top: 1px solid #e2e8f0; }
        .foot .brand { font-weight: 600; color: #475569; }
        .custom-block { background: #f8fafc; border-left: 4px solid #0ea5e9; padding: 14px 16px; margin: 16px 0; border-radius: 0 8px 8px 0; }
    </style>
</head>
<body>
    <div class="wrap">
        <div class="card">
            <div class="header">
                @if($logoUrl)
                    <img src="{{ $logoUrl }}" alt="Avusturya Gezi" width="180" style="max-width:180px;height:auto;">
                @endif
                <div class="brand">Avusturya Gezi</div>
            </div>
            <div class="title-block">
                <h1>
                    @if($type === 'approval')
                        Rezervasyonunuz Onaylandı
                    @elseif($type === 'payment_reminder')
                        Ödeme Hatırlatması
                    @else
                        Rezervasyon Bilgisi
                    @endif
                </h1>
                <div class="code">{{ $reservation->easy_code ?? $reservation->reservation_code }}</div>
            </div>
            <div class="body">
                <p>Merhaba <strong>{{ $name }}</strong>,</p>
                @if($customBody)
                    <div class="custom-block">{!! nl2br(e($customBody)) !!}</div>
                @endif

                <div class="detail-section">
                    <h2>Rezervasyon Detayları</h2>
                    <div class="row"><span class="label">Kolay Kod</span><span class="value">{{ $reservation->easy_code ?? $reservation->reservation_code }}</span></div>
                    <div class="row"><span class="label">Tur</span><span class="value">{{ $tourName }}</span></div>
                    <div class="row"><span class="label">Tarih</span><span class="value">{{ $dateStr }}</span></div>
                    <div class="row"><span class="label">Saat</span><span class="value">{{ $timeStr }}</span></div>
                    @if($reservation->relationLoaded('guests') && $reservation->guests->isNotEmpty())
                        <div class="row" style="flex-direction:column;align-items:stretch;">
                            <span class="label" style="margin-bottom:6px;">Katılımcılar</span>
                            <ul class="guests-list" style="margin:0;padding-left:18px;">
                                @foreach($reservation->guests as $g)
                                    <li><strong>{{ $g->first_name }} {{ $g->last_name }}</strong> — {{ $typeLabels[$g->type] ?? $g->type }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="row"><span class="label">Toplam Tutar</span><span class="value">{{ number_format($total, 2, ',', '.') }} EUR</span></div>
                    <div class="row"><span class="label">Ödenen</span><span class="value">{{ number_format($paid, 2, ',', '.') }} EUR</span></div>
                    <div class="row"><span class="label">Kalan</span><span class="value">{{ number_format($remaining, 2, ',', '.') }} EUR</span></div>
                    @if(!empty($contact['fullName'] ?? $contact['full_name'] ?? null) || !empty($contact['email'] ?? $contact['Email'] ?? null) || !empty($contact['phone'] ?? $contact['Phone'] ?? null))
                        <div class="row" style="flex-direction:column;align-items:stretch;">
                            <span class="label" style="margin-bottom:6px;">İletişim</span>
                            <span class="value" style="text-align:left;">
                                @if($fn = ($contact['fullName'] ?? $contact['full_name'] ?? null)){{ $fn }}<br>@endif
                                @if($em = ($contact['email'] ?? $contact['Email'] ?? null)){{ $em }}<br>@endif
                                @if($ph = ($contact['phone'] ?? $contact['Phone'] ?? null)){{ $ph }}@endif
                            </span>
                        </div>
                    @endif
                    @if($reservation->flight_preference || $reservation->flight_type || $reservation->airline || $reservation->custom_flight_notes)
                        <div class="row" style="flex-direction:column;align-items:stretch;">
                            <span class="label" style="margin-bottom:6px;">Uçuş Bilgileri</span>
                            <span class="value" style="text-align:left;">
                                @if($reservation->flight_preference) Tercih: {{ $reservation->flight_preference }}<br>@endif
                                @if($reservation->flight_type) Tip: {{ $reservation->flight_type }}<br>@endif
                                @if($reservation->airline) Havayolu: {{ $reservation->airline }}<br>@endif
                                @if($reservation->custom_flight_notes) Not: {{ $reservation->custom_flight_notes }}@endif
                            </span>
                        </div>
                    @endif
                </div>

                @if(!$customBody)
                    @if($type === 'approval')
                        <p>Ödeme için havale/EFT yaparken açıklama alanına <strong>{{ $reservation->easy_code }}</strong> yazınız.</p>
                    @elseif($type === 'payment_reminder')
                        <p>Havale/EFT açıklamasına <strong>{{ $reservation->easy_code }}</strong> yazmayı unutmayınız.</p>
                    @endif
                @endif
            </div>
            <div class="foot">
                <span class="brand">Avusturya Gezi</span><br>
                Bu e-posta sistem tarafından gönderilmiştir. Sorularınız için bizi arayabilir veya e-posta ile yazabilirsiniz.
            </div>
        </div>
    </div>
</body>
</html>
