#!/bin/bash

# Avusturya Gezi - Tam Kurulum Scripti
# Bu script tüm gereksinimleri kurar ve sistemi hazırlar

set -e

echo "🚀 Avusturya Gezi - Tam Kurulum Başlıyor..."
echo ""

# Renkler
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# 1. Homebrew kontrolü
echo "📦 Homebrew kontrol ediliyor..."
if ! command -v brew &> /dev/null; then
    echo -e "${YELLOW}⚠️  Homebrew kurulu değil. Kurulum başlatılıyor...${NC}"
    /bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
    
    # PATH'e ekle (Apple Silicon için)
    if [ -f /opt/homebrew/bin/brew ]; then
        eval "$(/opt/homebrew/bin/brew shellenv)"
    fi
fi
echo -e "${GREEN}✅ Homebrew hazır${NC}"

# 2. PHP kurulumu
echo ""
echo "🐘 PHP kurulumu kontrol ediliyor..."
if ! command -v php &> /dev/null; then
    echo -e "${YELLOW}⚠️  PHP kurulu değil. Kurulum başlatılıyor...${NC}"
    brew install php@8.2
    brew link php@8.2
fi
echo -e "${GREEN}✅ PHP hazır: $(php -v | head -1)${NC}"

# 3. Composer kurulumu
echo ""
echo "📦 Composer kurulumu kontrol ediliyor..."
if ! command -v composer &> /dev/null; then
    echo -e "${YELLOW}⚠️  Composer kurulu değil. Kurulum başlatılıyor...${NC}"
    curl -sS https://getcomposer.org/installer | php
    sudo mv composer.phar /usr/local/bin/composer
    sudo chmod +x /usr/local/bin/composer
fi
echo -e "${GREEN}✅ Composer hazır: $(composer --version | head -1)${NC}"

# 4. MySQL kurulumu
echo ""
echo "🗄️  MySQL kurulumu kontrol ediliyor..."
if ! command -v mysql &> /dev/null; then
    echo -e "${YELLOW}⚠️  MySQL kurulu değil. Kurulum başlatılıyor...${NC}"
    brew install mysql
    brew services start mysql
    sleep 3
fi
echo -e "${GREEN}✅ MySQL hazır${NC}"

# 5. Veritabanı oluşturma
echo ""
echo "🗄️  Veritabanı oluşturuluyor..."
mysql -u root -e "CREATE DATABASE IF NOT EXISTS avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;" 2>/dev/null || {
    echo -e "${YELLOW}⚠️  MySQL root şifresi gerekebilir. Lütfen şifrenizi girin:${NC}"
    read -s MYSQL_PASSWORD
    mysql -u root -p"$MYSQL_PASSWORD" -e "CREATE DATABASE IF NOT EXISTS avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
}
echo -e "${GREEN}✅ Veritabanı hazır${NC}"

# 6. Backend dizinine geç
cd "$(dirname "$0")"
echo ""
echo "📁 Backend dizinine geçiliyor..."

# 7. .env dosyası oluşturma
echo ""
echo "⚙️  .env dosyası oluşturuluyor..."
if [ ! -f .env ]; then
    cat > .env << 'EOF'
APP_NAME="Avusturya Gezi API"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost:8000

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=avusturya_gezi
DB_USERNAME=root
DB_PASSWORD=

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=mailpit
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="hello@example.com"
MAIL_FROM_NAME="${APP_NAME}"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=
AWS_USE_PATH_STYLE_ENDPOINT=false

VITE_APP_NAME="${APP_NAME}"

STRIPE_KEY=
STRIPE_SECRET=
STRIPE_WEBHOOK_SECRET=

FRONTEND_URL=http://localhost:3000
EOF
    echo -e "${GREEN}✅ .env dosyası oluşturuldu${NC}"
else
    echo -e "${YELLOW}⚠️  .env dosyası zaten mevcut${NC}"
fi

# 8. Composer paketlerini kur
echo ""
echo "📦 Composer paketleri kuruluyor..."
composer install --no-interaction --prefer-dist
echo -e "${GREEN}✅ Composer paketleri kuruldu${NC}"

# 9. Laravel key generate
echo ""
echo "🔑 Laravel application key oluşturuluyor..."
php artisan key:generate --force
echo -e "${GREEN}✅ Application key oluşturuldu${NC}"

# 10. Storage link
echo ""
echo "🔗 Storage link oluşturuluyor..."
php artisan storage:link 2>/dev/null || echo -e "${YELLOW}⚠️  Storage link zaten mevcut${NC}"
echo -e "${GREEN}✅ Storage link hazır${NC}"

# 11. Migration'ları çalıştır
echo ""
echo "🗄️  Veritabanı migration'ları çalıştırılıyor..."
php artisan migrate --force
echo -e "${GREEN}✅ Migration'lar tamamlandı${NC}"

# 12. Seeder çalıştır
echo ""
echo "🌱 Test verileri ekleniyor..."
php artisan db:seed --force
echo -e "${GREEN}✅ Test verileri eklendi${NC}"

# 13. Cache temizle
echo ""
echo "🧹 Cache temizleniyor..."
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
echo -e "${GREEN}✅ Cache temizlendi${NC}"

echo ""
echo -e "${GREEN}🎉 Kurulum tamamlandı!${NC}"
echo ""
echo "📋 Sonraki adımlar:"
echo "1. Backend server'ı başlatın:"
echo "   cd backend && php artisan serve"
echo ""
echo "2. Frontend'i başlatın (başka bir terminal'de):"
echo "   cd 'avusturya gezi' && npm run dev"
echo ""
echo "3. Admin panel'e giriş yapın:"
echo "   Email: admin@avusturyagezi.com"
echo "   Şifre: password"
echo ""
