#!/bin/bash

# Backend Server Başlatma Scripti
# Bu script PHP'yi bulup backend server'ı başlatır

echo "🔍 PHP aranıyor..."

# PHP'yi bul
PHP_PATH=""

# Homebrew PHP
if [ -f "/usr/local/bin/php" ]; then
    PHP_PATH="/usr/local/bin/php"
    echo "✅ Homebrew PHP bulundu: $PHP_PATH"
# MAMP PHP
elif [ -d "/Applications/MAMP/bin/php" ]; then
    PHP_VERSION=$(ls -t /Applications/MAMP/bin/php/ | head -1)
    PHP_PATH="/Applications/MAMP/bin/php/$PHP_VERSION/bin/php"
    if [ -f "$PHP_PATH" ]; then
        echo "✅ MAMP PHP bulundu: $PHP_PATH"
    fi
# XAMPP PHP
elif [ -f "/Applications/XAMPP/xamppfiles/bin/php" ]; then
    PHP_PATH="/Applications/XAMPP/xamppfiles/bin/php"
    echo "✅ XAMPP PHP bulundu: $PHP_PATH"
# Sistem PHP
elif [ -f "/usr/bin/php" ]; then
    PHP_PATH="/usr/bin/php"
    echo "✅ Sistem PHP bulundu: $PHP_PATH"
fi

if [ -z "$PHP_PATH" ] || [ ! -f "$PHP_PATH" ]; then
    echo "❌ PHP bulunamadı!"
    echo ""
    echo "💡 PHP kurulumu için:"
    echo "   Homebrew: brew install php"
    echo "   veya MAMP/XAMPP kullanın"
    exit 1
fi

# PHP versiyonunu kontrol et
PHP_VERSION=$($PHP_PATH -v | head -1)
echo "📦 PHP Versiyonu: $PHP_VERSION"

# Backend dizinine git
cd "$(dirname "$0")" || exit 1

echo ""
echo "🚀 Backend server başlatılıyor..."
echo "📍 URL: http://localhost:8000"
echo ""

# Server'ı başlat
$PHP_PATH artisan serve --host=127.0.0.1 --port=8000
