<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Fatura #<?php echo e($invoice->invoice_no); ?></title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 14px; color: #333; }
        .header { margin-bottom: 20px; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
        .logo { float: left; width: 150px; }
        .company-info { float: right; text-align: right; font-size: 12px; }
        .invoice-title { clear: both; margin-top: 30px; margin-bottom: 20px; }
        .invoice-details { margin-bottom: 30px; }
        .table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .table th, .table td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .table th { background-color: #f8f9fa; }
        .totals { float: right; margin-top: 10px; width: 300px; }
        .totals-row { display: flex; justify-content: space-between; margin-bottom: 5px; }
        .total-final { font-weight: bold; font-size: 16px; border-top: 1px solid #333; padding-top: 5px; }
        .footer { position: fixed; bottom: 0; left: 0; right: 0; font-size: 10px; text-align: center; color: #777; border-top: 1px solid #eee; padding-top: 5px; }
    </style>
</head>
<body>

<div class="header">
    <div class="logo">
        <img src="https://ranpa.web.tr/reisenlogo.png" style="width: 150px; height: auto;">
    </div>
    <div class="company-info">
        <strong>VIYANA REISEN KG</strong><br>
        Spitalgasse 21/1-2<br>
        1090 Wien / VIYANA / AVUSTURYA<br>
        YURTDISI, YURTDISI – YURTDISI<br>
        Tax Id: ATU77803389<br>
        Tel: +43 664 358 44 72
    </div>
    <div style="clear: both;"></div>
</div>

<div class="invoice-title">
    <h1>Fatura</h1>
</div>

<div class="invoice-details">
    <table width="100%">
        <tr>
            <td width="50%" valign="top">
                <strong>Sayın:</strong><br>
                <?php echo e($invoice->billing_details['name'] ?? '–'); ?><br>
                <?php echo e($invoice->billing_details['address'] ?? ''); ?><br>
                <?php echo e($invoice->billing_details['zip_code'] ?? ''); ?> <?php echo e($invoice->billing_details['city'] ?? ''); ?><br>
                <?php echo e($invoice->billing_details['country'] ?? ''); ?><br>
                <?php if(!empty($invoice->billing_details['tax_id'])): ?>
                    Vergi No: <?php echo e($invoice->billing_details['tax_id']); ?><br>
                <?php endif; ?>
            </td>
            <td width="50%" valign="top" style="text-align: right;">
                <strong>Fatura No:</strong> <?php echo e($invoice->invoice_no); ?><br>
                <strong>Tarih:</strong> <?php echo e($invoice->invoice_date->format('d.m.Y')); ?><br>
                <strong>Rezervasyon:</strong> <?php echo e($invoice->reservation->reservation_code); ?><br>
                <strong>Durum:</strong> <?php echo e($invoice->status === 'paid' ? 'Ödendi' : 'Bekliyor'); ?>

            </td>
        </tr>
    </table>
</div>

<table class="table">
    <thead>
        <tr>
            <th>Açıklama</th>
            <th style="width: 50px;">Miktar</th>
            <th style="width: 100px;">Birim Fiyat</th>
            <th style="width: 100px;">Toplam</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($item['description']); ?></td>
                <td style="text-align: center;"><?php echo e($item['quantity']); ?></td>
                <td style="text-align: right;"><?php echo e(number_format($item['unit_price'], 2, ',', '.')); ?> €</td>
                <td style="text-align: right;"><?php echo e(number_format($item['total'], 2, ',', '.')); ?> €</td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<div class="totals">
    <table width="100%">
        <tr>
            <td align="right">Ara Toplam:</td>
            <td align="right" width="100"><?php echo e(number_format($invoice->total_price, 2, ',', '.')); ?> €</td>
        </tr>
        <?php if($invoice->discount_amount > 0): ?>
        <tr>
            <td align="right">İndirim:</td>
            <td align="right">-<?php echo e(number_format($invoice->discount_amount, 2, ',', '.')); ?> €</td>
        </tr>
        <?php endif; ?>
        <?php if($invoice->tax_amount > 0): ?>
        <tr>
            <td align="right">Vergi:</td>
            <td align="right"><?php echo e(number_format($invoice->tax_amount, 2, ',', '.')); ?> €</td>
        </tr>
        <?php endif; ?>
        <tr>
            <td align="right" style="font-weight: bold; border-top: 1px solid #333; padding-top: 5px;">Toplam:</td>
            <td align="right" style="font-weight: bold; border-top: 1px solid #333; padding-top: 5px;"><?php echo e(number_format($invoice->total_price - $invoice->discount_amount + $invoice->tax_amount, 2, ',', '.')); ?> €</td>
        </tr>
    </table>
</div>

<div class="footer">
    Bu fatura elektronik ortamda oluşturulmuştur.
</div>

</body>
</html>
<?php /**PATH /Users/denizyildiz/Desktop/avusturya gezi yeni/backend/resources/views/invoices/pdf.blade.php ENDPATH**/ ?>